<?php

require_once('config.php');

check_user();

check_activation(true);

require_once('classes/fb.php');

require_once('classes/user.php');

$fb = new Facebook();

$fb_user = $fb->get_fb_user();

$page = 'settings';

$save_settings['success'] = false;
$save_settings['fb_success'] = false;

$user_class     = new User();
$user           = $user_class->get_user();
$gen_settings   = $user_class->getAppSettings();

$settings       = $user;
$timezones      = $user_class->timezones();

if(isset($_POST['submit']) && $_POST['submit'] == 'settings')
{
    if(DEMO_VERSION && $user_class->is_admin() < 2){
        $save_settings['errors'][] = DEMO_ERROR;
    }else {
        $app_id = empty($_POST['app_id']) ? '' : $_POST['app_id'];
        $app_secret = empty($_POST['app_secret']) ? '' : $_POST['app_secret'];

        $name = empty($_POST['name']) ? '' : $_POST['name'];
        $email = empty($_POST['email']) ? '' : $_POST['email'];
        $timezone = empty($_POST['timezone']) ? '' : $_POST['timezone'];

        $cpassword = empty($_POST['cpassword']) ? '' : $_POST['cpassword'];
        $npassword = empty($_POST['password']) ? '' : $_POST['password'];
        $repassword = empty($_POST['repassword']) ? '' : $_POST['repassword'];

        $error = 0;
        $change_fb = false;
        $change_user = false;
        $change_pswrd = false;

        if (check_admin() != 1 && ($user['app_id'] != $app_id || $user['app_secret'] != $app_secret)) {
            $change_fb = true;
            if ($app_id == "") {
                $save_settings['errors'][] = "App Id is required.";
                $error = 1;
            }

            if ($app_secret == "") {
                $save_settings['errors'][] = "App Secret is required.";
                $error = 1;
            }

            if ($error == 0) {
                if (!$fb->check_app($app_id, $app_secret)) {
                    $save_settings['errors'][] = "This app does not exist in facebook.";
                    $error = 1;
                }
            }

            if ($error == 1) {
                $settings['app_id'] = $app_id;
                $settings['app_secret'] = $app_secret;
            }
        }
        //echo"<pre>";print_r($_POST);die();
        if ($user['name'] != $name || $user['email'] != $email || $user['timezone'] != $timezone) {
            $change_user = true;

            if ($name == '') {
                $error = 1;
                $save_settings['errors'][] = "Field Name is required.";
            }

            if ($email == '') {
                $error = 1;
                $save_settings['errors'][] = "Email is required.";
            }

            if (!FILTER_VAR($email, FILTER_VALIDATE_EMAIL)) {
                $error = 1;
                $save_settings['errors'][] = "Email is not valid.";
            }

            if (!$user_class->check_email($email)) {
                $error = 1;
                $save_settings['errors'][] = "This email already in use.";
            }

            if ($timezone == '') {
                $error = 1;
                $save_settings['errors'][] = "Timezone is required.";
            }

            if ($error == 1) {
                $settings['name'] = $name;
                $settings['email'] = $email;
                $settings['timezone'] = $timezone;
            }
        }

        if ($cpassword != '' || $npassword != '' || $repassword != '') {
            $change_pswrd = true;

            if ($user['password'] != sha1($cpassword)) {
                $error = 1;
                $save_settings['errors'][] = "Incorrect password.";
            }

            if ($npassword != $repassword) {
                $error = 1;
                $save_settings['errors'][] = "Passwords mismatch.";
            }
        }

        if ($error == 0) {
            if (!empty($_FILES['file_groups'])) {
                $save_settings['file_success'] = false;
                $file = $_FILES['file_groups'];

                if (!$file['error']) {
                    if ($filename = $user_class->upload_file($file)) {
                        $save_settings['file_success'] = $fb->import_groups($user['id'], $user['fb_token'], $filename);
                    }
                }else{
                    $max_size = $user_class->file_upload_max_size()/1024/1024;
                    $save_settings['file_error'] = "Maximum file size is ".$max_size." Mb, please change your server settings.";
                }
            }

            if ($change_fb) {
                $user_class->set_fb_app($app_id, $app_secret);
                $save_settings['fb_success'] = true;
            }

            if ($change_user) {
                $upd_data['name'] = $name;
                $upd_data['email'] = $email;
                $upd_data['timezone'] = $timezone;
                $user_class->change_user_data($upd_data);
            }

            if ($change_pswrd) {
                $user_class->change_password($npassword);
            }

            $save_settings['success'] = true;

            if (check_admin()) {
                $upd_data = array();
                $upd_data['param'] = 'allow_registered';
                $upd_data['value'] = empty($_POST['allow_registered']) ? 0 : $_POST['allow_registered'];
                $user_class->set_general_settings($upd_data);
                $gen_settings = $user_class->getAppSettings();
            }

            $user = $user_class->get_user();
            $settings = $user;
        }
    }
}


/*
if($_POST['submit'] == 'general_settings')
{
    $allow_registered = empty($_POST['allow_registered']) ? 0 : 1;
    if(check_admin()){
        $user_class->set_general_settings(array('param' => 'allow_registered', 'value' => $allow_registered));
        $save_settings['general_settings']['success'] = true;
        $gen_settings   = $user_class->getAppSettings();
    }
}
*/

include('templates/settings.php');